/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Objects;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.artifacts.component.DefaultBuildIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.BuildIdentity;

public class DefaultProjectComponentIdentifier
implements ProjectComponentIdentifier {
    private final BuildIdentifier buildIdentifier;
    private final String projectPath;
    private String displayName;

    public DefaultProjectComponentIdentifier(BuildIdentifier buildIdentifier, String projectPath) {
        assert (buildIdentifier != null) : "build cannot be null";
        assert (projectPath != null) : "project path cannot be null";
        this.buildIdentifier = buildIdentifier;
        this.projectPath = projectPath;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = "project " + DefaultProjectComponentIdentifier.fullPath(this.buildIdentifier, this.projectPath);
        }
        return this.displayName;
    }

    public BuildIdentifier getBuild() {
        return this.buildIdentifier;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getProjectName() {
        if (this.projectPath.equals(":")) {
            return this.buildIdentifier.getName();
        }
        int index = this.projectPath.lastIndexOf(58);
        return this.projectPath.substring(index + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectComponentIdentifier that = (DefaultProjectComponentIdentifier)o;
        return Objects.equal((Object)this.projectPath, (Object)that.projectPath) && Objects.equal((Object)this.buildIdentifier, (Object)that.buildIdentifier);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectPath, this.buildIdentifier});
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static String fullPath(BuildIdentifier build, String projectPath) {
        if (build.getName().equals(":")) {
            return projectPath;
        }
        if (projectPath.equals(":")) {
            return ":" + build.getName();
        }
        return ":" + build.getName() + projectPath;
    }

    public static ProjectComponentIdentifier newProjectId(IncludedBuild build, String projectPath) {
        DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(build.getName());
        return new DefaultProjectComponentIdentifier(buildIdentifier, projectPath);
    }

    public static ProjectComponentIdentifier newProjectId(BuildIdentifier buildIdentifier, String projectPath) {
        return new DefaultProjectComponentIdentifier(buildIdentifier, projectPath);
    }

    public static ProjectComponentIdentifier newProjectId(Project project) {
        BuildIdentifier buildId = ((BuildIdentity)((ProjectInternal)project).getServices().get(BuildIdentity.class)).getCurrentBuild();
        return new DefaultProjectComponentIdentifier(buildId, project.getPath());
    }
}

