/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.util.Collections;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.IvyDependencyDescriptorFactory;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.util.WrapUtil;

public class DefaultDependencyDescriptorFactory
implements DependencyDescriptorFactory {
    private List<IvyDependencyDescriptorFactory> dependencyDescriptorFactories;

    public DefaultDependencyDescriptorFactory(IvyDependencyDescriptorFactory ... dependencyDescriptorFactories) {
        this.dependencyDescriptorFactories = WrapUtil.toList((Object[])dependencyDescriptorFactories);
    }

    @Override
    public LocalOriginDependencyMetadata createDependencyDescriptor(ComponentIdentifier componentId, String clientConfiguration, AttributeContainer attributes, ModuleDependency dependency) {
        IvyDependencyDescriptorFactory factoryInternal = this.findFactoryForDependency(dependency);
        return factoryInternal.createDependencyDescriptor(componentId, clientConfiguration, attributes, dependency);
    }

    @Override
    public LocalOriginDependencyMetadata createDependencyConstraintDescriptor(ComponentIdentifier componentId, String clientConfiguration, AttributeContainer attributes, DependencyConstraint dependencyConstraint) {
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(this.nullToEmpty(dependencyConstraint.getGroup()), this.nullToEmpty(dependencyConstraint.getName()), dependencyConstraint.getVersionConstraint());
        return new LocalComponentDependencyMetadata(componentId, (ComponentSelector)selector, clientConfiguration, attributes, null, Collections.<IvyArtifactName>emptyList(), Collections.<ExcludeMetadata>emptyList(), false, false, true, true, dependencyConstraint.getReason());
    }

    private IvyDependencyDescriptorFactory findFactoryForDependency(ModuleDependency dependency) {
        for (IvyDependencyDescriptorFactory ivyDependencyDescriptorFactory : this.dependencyDescriptorFactories) {
            if (!ivyDependencyDescriptorFactory.canConvert(dependency)) continue;
            return ivyDependencyDescriptorFactory;
        }
        throw new InvalidUserDataException("Can't map dependency of type: " + dependency.getClass());
    }

    private String nullToEmpty(String input) {
        return input == null ? "" : input;
    }
}

