/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.LocalComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder {
    private final DependencyMetaDataProvider metaDataProvider;
    private final ComponentIdentifierFactory componentIdentifierFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final ProjectFinder projectFinder;
    private final LocalComponentMetadataBuilder localComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final MetadataHolder holder;

    public DefaultRootComponentMetadataBuilder(DependencyMetaDataProvider metaDataProvider, ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ProjectFinder projectFinder, LocalComponentMetadataBuilder localComponentMetadataBuilder, ConfigurationsProvider configurationsProvider) {
        this.metaDataProvider = metaDataProvider;
        this.componentIdentifierFactory = componentIdentifierFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.projectFinder = projectFinder;
        this.localComponentMetadataBuilder = localComponentMetadataBuilder;
        this.configurationsProvider = configurationsProvider;
        this.holder = new MetadataHolder();
    }

    @Override
    public ComponentResolveMetadata toRootComponentMetaData() {
        Module module = this.metaDataProvider.getModule();
        ComponentIdentifier componentIdentifier = this.componentIdentifierFactory.createComponentIdentifier(module);
        DefaultLocalComponentMetadata metaData = this.holder.tryCached(componentIdentifier);
        if (metaData != null) {
            return metaData;
        }
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectInternal project = this.projectFinder.findProject(module.getProjectPath());
        AttributesSchemaInternal schema = project == null ? null : (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
        metaData = new DefaultLocalComponentMetadata(moduleVersionIdentifier, componentIdentifier, module.getStatus(), schema);
        this.localComponentMetadataBuilder.addConfigurations(metaData, this.configurationsProvider.getAll());
        this.holder.cachedValue = metaData;
        return metaData;
    }

    @Override
    public RootComponentMetadataBuilder withConfigurationsProvider(ConfigurationsProvider alternateProvider) {
        return new DefaultRootComponentMetadataBuilder(this.metaDataProvider, this.componentIdentifierFactory, this.moduleIdentifierFactory, this.projectFinder, this.localComponentMetadataBuilder, alternateProvider);
    }

    public MutationValidator getValidator() {
        return this.holder;
    }

    private static class MetadataHolder
    implements MutationValidator {
        private DefaultLocalComponentMetadata cachedValue;

        private MetadataHolder() {
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            if (type == MutationValidator.MutationType.DEPENDENCIES || type == MutationValidator.MutationType.ARTIFACTS || type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES) {
                this.cachedValue = null;
            }
        }

        DefaultLocalComponentMetadata tryCached(ComponentIdentifier id) {
            if (this.cachedValue != null) {
                if (this.cachedValue.getComponentId().equals(id)) {
                    return this.cachedValue;
                }
                this.cachedValue = null;
            }
            return null;
        }
    }
}

