/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import javax.annotation.Nullable;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.util.BuildCommencedTimeProvider;

class DefaultCachedMetadata
implements ModuleMetadataCache.CachedMetadata {
    private final ModuleSource moduleSource;
    private final long ageMillis;
    private final ModuleComponentResolveMetadata metadata;
    private ModuleComponentResolveMetadata processedMetadata;

    public DefaultCachedMetadata(ModuleMetadataCacheEntry entry, ModuleComponentResolveMetadata metadata, BuildCommencedTimeProvider timeProvider) {
        this.moduleSource = entry.moduleSource;
        this.ageMillis = timeProvider.getCurrentTime() - entry.createTimestamp;
        this.metadata = metadata;
    }

    @Override
    public boolean isMissing() {
        return this.metadata == null;
    }

    @Override
    public ModuleSource getModuleSource() {
        return this.moduleSource;
    }

    @Override
    public ResolvedModuleVersion getModuleVersion() {
        return this.isMissing() ? null : new DefaultResolvedModuleVersion(this.getMetadata().getId());
    }

    @Override
    public ModuleComponentResolveMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public long getAgeMillis() {
        return this.ageMillis;
    }

    @Override
    @Nullable
    public ModuleComponentResolveMetadata getProcessedMetadata() {
        return this.processedMetadata;
    }

    @Override
    public void setProcessedMetadata(ModuleComponentResolveMetadata processedMetadata) {
        this.processedMetadata = processedMetadata;
    }
}

