/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.DefaultStaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;

@Incubating
public class CreateStaticLibrary
extends DefaultTask
implements ObjectFilesToBinary {
    private final ConfigurableFileCollection source;
    private NativeToolChainInternal toolChain;
    private NativePlatformInternal targetPlatform;
    private RegularFileProperty outputFile;
    private List<String> staticLibArgs = new ArrayList<String>();

    public CreateStaticLibrary() {
        this.source = this.getProject().files(new Object[0]);
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return NativeToolChainInternal.Identifier.identify(CreateStaticLibrary.this.toolChain, CreateStaticLibrary.this.targetPlatform);
            }
        });
        this.outputFile = this.newOutputFile();
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return this.source;
    }

    @Override
    public void source(Object source) {
        this.source.from(new Object[]{source});
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void link() {
        DefaultStaticLibraryArchiverSpec spec = new DefaultStaticLibraryArchiverSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setOutputFile(this.getOutputFile());
        spec.objectFiles((Iterable<File>)this.getSource());
        spec.args(this.getStaticLibArgs());
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        spec.setOperationLogger(operationLogger);
        Compiler compiler = (Compiler)Cast.uncheckedCast((Object)this.toolChain.select(this.targetPlatform).newCompiler(spec.getClass()));
        WorkResult result = BuildOperationLoggingCompilerDecorator.wrap(compiler).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    @Internal
    public NativeToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(NativeToolChain toolChain) {
        this.toolChain = (NativeToolChainInternal)toolChain;
    }

    @Nested
    public NativePlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public void setTargetPlatform(NativePlatform targetPlatform) {
        this.targetPlatform = (NativePlatformInternal)targetPlatform;
    }

    @OutputFile
    public File getOutputFile() {
        return ((RegularFile)this.outputFile.get()).getAsFile();
    }

    public void setOutputFile(File outputFile) {
        this.outputFile.set(outputFile);
    }

    public void setOutputFile(Provider<? extends RegularFile> outputFile) {
        this.outputFile.set(outputFile);
    }

    @Internal
    public RegularFileProperty getBinaryFile() {
        return this.outputFile;
    }

    @Input
    public List<String> getStaticLibArgs() {
        return this.staticLibArgs;
    }

    public void setStaticLibArgs(List<String> staticLibArgs) {
        this.staticLibArgs = staticLibArgs;
    }
}

