/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0011\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004J\b\u0010\u0018\u001a\u00020\u0014H&J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0000H\u0004J\u0006\u0010\u001b\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion;", "", "numbers", "", "", "([I)V", "major", "getMajor", "()I", "minor", "getMinor", "getNumbers", "()[I", "patch", "getPatch", "rest", "", "getRest", "()Ljava/util/List;", "equals", "", "other", "hashCode", "isAtLeast", "isCompatible", "isCompatibleTo", "ourVersion", "toArray", "toString", "", "Companion", "util.runtime"})
public abstract class BinaryVersion {
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private final List<Integer> rest;
    @NotNull
    private final int[] numbers;
    private static final int UNKNOWN = -1;
    public static final Companion Companion = new Companion(null);

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public final List<Integer> getRest() {
        return this.rest;
    }

    public abstract boolean isCompatible();

    @NotNull
    public final int[] toArray() {
        return this.numbers;
    }

    protected final boolean isCompatibleTo(@NotNull BinaryVersion ourVersion) {
        Intrinsics.checkParameterIsNotNull((Object)ourVersion, (String)"ourVersion");
        return this.major == 0 ? ourVersion.major == 0 && this.minor == ourVersion.minor : this.major == ourVersion.major && this.minor <= ourVersion.minor;
    }

    public final boolean isAtLeast(int major, int minor, int patch) {
        if (this.major > major) {
            return true;
        }
        if (this.major < major) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        return this.patch >= patch;
    }

    @NotNull
    public String toString() {
        int item$iv;
        int it;
        int[] $receiver$iv = this.toArray();
        ArrayList<Integer> list$iv = new ArrayList<Integer>();
        int n = $receiver$iv.length;
        for (int i = 0; i < n && (it = (item$iv = $receiver$iv[i])) != BinaryVersion.Companion.getUNKNOWN(); ++i) {
            list$iv.add(item$iv);
        }
        List versions = list$iv;
        return versions.isEmpty() ? "unknown" : CollectionsKt.joinToString$default((Iterable)versions, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        return other != null && Intrinsics.areEqual(this.getClass(), other.getClass()) && this.major == ((BinaryVersion)other).major && this.minor == ((BinaryVersion)other).minor && this.patch == ((BinaryVersion)other).patch && Intrinsics.areEqual(this.rest, ((BinaryVersion)other).rest);
    }

    public int hashCode() {
        int result2 = this.major;
        result2 += 31 * result2 + this.minor;
        result2 += 31 * result2 + this.patch;
        result2 += 31 * result2 + ((Object)this.rest).hashCode();
        return result2;
    }

    @NotNull
    public final int[] getNumbers() {
        return this.numbers;
    }

    public BinaryVersion(int ... numbers) {
        Intrinsics.checkParameterIsNotNull((Object)numbers, (String)"numbers");
        this.numbers = numbers;
        Integer n = ArraysKt.getOrNull((int[])this.numbers, (int)0);
        this.major = n != null ? n : BinaryVersion.Companion.getUNKNOWN();
        Integer n2 = ArraysKt.getOrNull((int[])this.numbers, (int)1);
        this.minor = n2 != null ? n2 : BinaryVersion.Companion.getUNKNOWN();
        Integer n3 = ArraysKt.getOrNull((int[])this.numbers, (int)2);
        this.patch = n3 != null ? n3 : BinaryVersion.Companion.getUNKNOWN();
        this.rest = this.numbers.length > 3 ? CollectionsKt.toList((Iterable)ArraysKt.asList((int[])this.numbers).subList(3, this.numbers.length)) : CollectionsKt.emptyList();
    }

    static {
        UNKNOWN = -1;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion$Companion;", "", "()V", "UNKNOWN", "", "getUNKNOWN", "()I", "util.runtime"})
    public static final class Companion {
        private final int getUNKNOWN() {
            return UNKNOWN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

