/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SuspendOperatorsCheckers;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "UNSUPPORTED_OPERATOR_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "frontend"})
public final class SuspendOperatorsCheckers
implements SimpleDeclarationChecker {
    private static final Set<Name> UNSUPPORTED_OPERATOR_NAMES;
    public static final SuspendOperatorsCheckers INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        block0: {
            PsiElement psiElement;
            PsiElement psiElement2;
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
            if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend() || !((FunctionDescriptor)descriptor2).isOperator() || !UNSUPPORTED_OPERATOR_NAMES.contains(((FunctionDescriptor)descriptor2).getName()) || (psiElement2 = declaration.getModifierList()) == null || (psiElement2 = psiElement2.getModifier(KtTokens.OPERATOR_KEYWORD)) == null) break block0;
            PsiElement it = psiElement = psiElement2;
            diagnosticHolder.report(Errors.UNSUPPORTED.on(it, "suspend operator \"" + ((FunctionDescriptor)descriptor2).getName() + '\"'));
        }
    }

    private SuspendOperatorsCheckers() {
    }

    static {
        SuspendOperatorsCheckers suspendOperatorsCheckers;
        INSTANCE = suspendOperatorsCheckers = new SuspendOperatorsCheckers();
        UNSUPPORTED_OPERATOR_NAMES = SetsKt.setOf((Object[])new Name[]{OperatorNameConventions.CONTAINS, OperatorNameConventions.GET, OperatorNameConventions.SET});
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)expectActualTracker, (String)"expectActualTracker");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings, expectActualTracker);
    }
}

