/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DelegationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "checkDescriptor", "classDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "delegatedDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "delegatedToDescriptor", "frontend"})
public final class DelegationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ExpectActualTracker expectActualTracker) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)expectActualTracker, (String)"expectActualTracker");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        for (KtSuperTypeListEntry specifier : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            ClassDescriptor superTypeDescriptor;
            KtTypeReference ktTypeReference;
            KtTypeReference it;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            Object object = ((KtDelegatedSuperTypeEntry)specifier).getTypeReference();
            if (object == null || (object = (KotlinType)bindingContext.get(BindingContext.TYPE, it = (ktTypeReference = object))) == null) {
                continue;
            }
            Object superType = object;
            ClassifierDescriptor classifierDescriptor = ((KotlinType)superType).getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            if ((ClassDescriptor)classifierDescriptor == null) {
                continue;
            }
            Map map2 = DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, (ClassDescriptor)descriptor2, superTypeDescriptor, null, 4, null);
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator2.next();
                CallableMemberDescriptor delegated = (CallableMemberDescriptor)entry2.getKey();
                entry2 = entry;
                CallableMemberDescriptor delegatedTo = (CallableMemberDescriptor)entry2.getValue();
                this.checkDescriptor((KtClassOrObject)declaration, delegated, delegatedTo, diagnosticHolder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDescriptor(KtClassOrObject classDeclaration, CallableMemberDescriptor delegatedDescriptor, CallableMemberDescriptor delegatedToDescriptor, DiagnosticSink diagnosticHolder) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Set<CallableDescriptor> set = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatedDescriptor);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"DescriptorUtils.getAllOv\u2026tors(delegatedDescriptor)");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            CallableMemberDescriptor it;
            CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"it");
            CallableMemberDescriptor.Kind kind = callableMemberDescriptor.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind), (String)"it.kind");
            if (!kind.isReal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set set2 = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"OverridingUtil.filterOut\u2026toSet()\n                )");
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.unwrapFakeOverride(delegatedToDescriptor);
        Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"DescriptorUtils.unwrapFa\u2026de(delegatedToDescriptor)");
        Set reachableFromDelegated = SetsKt.minus(set2, (Object)callableMemberDescriptor.getOriginal());
        Iterable $receiver$iv2 = reachableFromDelegated;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CallableMemberDescriptor it;
            CallableMemberDescriptor callableMemberDescriptor2 = it = (CallableMemberDescriptor)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor2, (String)"it");
            if (!Intrinsics.areEqual((Object)((Object)callableMemberDescriptor2.getModality()), (Object)((Object)Modality.OPEN))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List nonAbstractReachable = (List)destination$iv$iv2;
        iterable = nonAbstractReachable;
        if (!iterable.isEmpty()) {
            diagnosticHolder.report(Errors.DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE.on((KtClassOrObject)((PsiElement)classDeclaration), delegatedDescriptor, nonAbstractReachable));
        }
    }
}

