/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;

public abstract class PsiManager
extends UserDataHolderBase {
    @NotNull
    public static PsiManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/PsiManager", "getInstance"));
        }
        PsiManager psiManager = project.getComponent(PsiManager.class);
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiManager", "getInstance"));
        }
        return psiManager;
    }

    @NotNull
    public abstract Project getProject();

    @Nullable
    public abstract PsiFile findFile(@NotNull VirtualFile var1);

    @Nullable
    public abstract FileViewProvider findViewProvider(@NotNull VirtualFile var1);

    @Nullable
    public abstract PsiDirectory findDirectory(@NotNull VirtualFile var1);

    public abstract boolean areElementsEquivalent(@Nullable PsiElement var1, @Nullable PsiElement var2);

    public abstract void reloadFromDisk(@NotNull PsiFile var1);

    public abstract void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener var1);

    public abstract void addPsiTreeChangeListener(@NotNull PsiTreeChangeListener var1, @NotNull Disposable var2);

    public abstract void removePsiTreeChangeListener(@NotNull PsiTreeChangeListener var1);

    @NotNull
    public abstract PsiModificationTracker getModificationTracker();

    public abstract void startBatchFilesProcessingMode();

    public abstract void finishBatchFilesProcessingMode();

    public abstract boolean isDisposed();

    public abstract void dropResolveCaches();

    public abstract void dropPsiCaches();

    public abstract boolean isInProject(@NotNull PsiElement var1);
}

