/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.pom.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.pom.PomManager;
import org.jetbrains.kotlin.com.intellij.pom.PomModelAspect;
import org.jetbrains.kotlin.com.intellij.pom.PomTransaction;
import org.jetbrains.kotlin.com.intellij.pom.event.PomModelEvent;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public abstract class PomTransactionBase
implements PomTransaction {
    private final PsiElement myScope;
    private final PomModelAspect myAspect;
    private final PomModelEvent myAccumulatedEvent;

    public PomTransactionBase(@NotNull PsiElement scope, @NotNull PomModelAspect aspect) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/pom/impl/PomTransactionBase", "<init>"));
        }
        if (aspect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aspect", "org/jetbrains/kotlin/com/intellij/pom/impl/PomTransactionBase", "<init>"));
        }
        this.myScope = scope;
        this.myAspect = aspect;
        this.myAccumulatedEvent = new PomModelEvent(PomManager.getModel(scope.getProject()));
    }

    @NotNull
    public PomModelEvent getAccumulatedEvent() {
        PomModelEvent pomModelEvent = this.myAccumulatedEvent;
        if (pomModelEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/pom/impl/PomTransactionBase", "getAccumulatedEvent"));
        }
        return pomModelEvent;
    }

    public void run() throws IncorrectOperationException {
        PomModelEvent event = this.runInner();
        if (event == null) {
            this.myAccumulatedEvent.registerChangeSet(this.myAspect, null);
            return;
        }
        this.myAccumulatedEvent.merge(event);
    }

    @Nullable
    public abstract PomModelEvent runInner() throws IncorrectOperationException;

    @NotNull
    public PsiElement getChangeScope() {
        PsiElement psiElement = this.myScope;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/pom/impl/PomTransactionBase", "getChangeScope"));
        }
        return psiElement;
    }

    @NotNull
    public PomModelAspect getTransactionAspect() {
        PomModelAspect pomModelAspect = this.myAspect;
        if (pomModelAspect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/pom/impl/PomTransactionBase", "getTransactionAspect"));
        }
        return pomModelAspect;
    }
}

