/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import org.gradle.StartParameter;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.buildsrc.BuildBuildSrcBuildOperationType;
import org.gradle.initialization.buildsrc.BuildSrcBuildListenerFactory;
import org.gradle.initialization.buildsrc.BuildSrcUpdateFactory;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.invocation.GradleBuildController;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildSourceBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSourceBuilder.class);
    public static final BuildBuildSrcBuildOperationType.Result BUILD_BUILDSRC_RESULT = new BuildBuildSrcBuildOperationType.Result(){};
    public static final String BUILD_SRC = "buildSrc";
    private final NestedBuildFactory nestedBuildFactory;
    private final ClassLoaderScope classLoaderScope;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CachedClasspathTransformer cachedClasspathTransformer;
    private final BuildSrcBuildListenerFactory buildSrcBuildListenerFactory;

    public BuildSourceBuilder(NestedBuildFactory nestedBuildFactory, ClassLoaderScope classLoaderScope, BuildOperationExecutor buildOperationExecutor, CachedClasspathTransformer cachedClasspathTransformer, BuildSrcBuildListenerFactory buildSrcBuildListenerFactory) {
        this.nestedBuildFactory = nestedBuildFactory;
        this.classLoaderScope = classLoaderScope;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
        this.buildSrcBuildListenerFactory = buildSrcBuildListenerFactory;
    }

    public ClassLoaderScope buildAndCreateClassLoader(GradleInternal gradle, StartParameter startParameter) {
        ClassPath classpath = this.createBuildSourceClasspath(gradle, startParameter);
        return this.classLoaderScope.createChild(startParameter.getCurrentDir().getAbsolutePath()).export(this.cachedClasspathTransformer.transform(classpath)).lock();
    }

    ClassPath createBuildSourceClasspath(final GradleInternal gradle, final StartParameter startParameter) {
        assert (startParameter.getCurrentDir() != null && startParameter.getBuildFile() == null);
        LOGGER.debug("Starting to build the build sources.");
        if (!startParameter.getCurrentDir().isDirectory()) {
            LOGGER.debug("Gradle source dir does not exist. We leave.");
            return ClassPath.EMPTY;
        }
        return (ClassPath)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ClassPath>(){

            public ClassPath call(BuildOperationContext context) {
                ClassPath classPath = BuildSourceBuilder.this.buildBuildSrc(startParameter);
                context.setResult((Object)BUILD_BUILDSRC_RESULT);
                return classPath;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Build buildSrc").progressDisplayName("Building buildSrc").details((Object)new BuildBuildSrcBuildOperationType.Details(){

                    public String getBuildPath() {
                        return gradle.getIdentityPath().toString();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath buildBuildSrc(StartParameter startParameter) {
        BuildController buildController = this.createBuildController(startParameter);
        try {
            DefaultClassPath defaultClassPath = new BuildSrcUpdateFactory(buildController, this.buildSrcBuildListenerFactory).create();
            return defaultClassPath;
        }
        finally {
            buildController.stop();
        }
    }

    private BuildController createBuildController(StartParameter startParameter) {
        GradleLauncher gradleLauncher = this.buildGradleLauncher(startParameter);
        return new GradleBuildController(gradleLauncher);
    }

    private GradleLauncher buildGradleLauncher(StartParameter startParameter) {
        StartParameter startParameterArg = startParameter.newInstance();
        startParameterArg.setProjectProperties(startParameter.getProjectProperties());
        startParameterArg.setSearchUpwards(false);
        startParameterArg.setProfile(startParameter.isProfile());
        GradleLauncher gradleLauncher = this.nestedBuildFactory.nestedInstance(BuildDefinition.fromStartParameter(startParameterArg));
        GradleInternal build = gradleLauncher.getGradle();
        if (build.getParent().findIdentityPath() == null) {
            Path path = build.getParent().getParent().getIdentityPath().child(startParameter.getCurrentDir().getParentFile().getName()).child(startParameter.getCurrentDir().getName());
            build.setIdentityPath(path);
        }
        return gradleLauncher;
    }
}

