/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.InputStream;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.internal.file.FileType;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.util.GFileUtils;

class SnapshotFileTreeElement
extends AbstractFileTreeElement {
    private final FileSnapshot _snapshot;
    private final FileSystem _fileSystem;
    private File _file;

    SnapshotFileTreeElement(FileSnapshot snapshot, FileSystem fileSystem) {
        super((Chmod)fileSystem);
        this._snapshot = snapshot;
        this._fileSystem = fileSystem;
    }

    public String getDisplayName() {
        return "file '" + this.getFile() + "'";
    }

    public File getFile() {
        if (this._file == null) {
            this._file = new File(this._snapshot.getPath());
        }
        return this._file;
    }

    public InputStream open() {
        return GFileUtils.openInputStream((File)this.getFile());
    }

    public boolean isDirectory() {
        return this._snapshot.getType() == FileType.Directory;
    }

    public long getLastModified() {
        return this.getFile().lastModified();
    }

    public long getSize() {
        return this.getFile().length();
    }

    public String getName() {
        return this._snapshot.getName();
    }

    public String getPath() {
        return this._snapshot.getPath();
    }

    public RelativePath getRelativePath() {
        return this._snapshot.getRelativePath();
    }

    public int getMode() {
        return this._fileSystem.getUnixMode(this.getFile());
    }
}

