/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.tasks.TaskFilePropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePropertyContainer<T extends TaskFilePropertyBuilder & TaskFilePropertySpec>
implements Iterable<T> {
    private final List<T> properties = Lists.newArrayList();
    private boolean changed;
    private int unnamedPropertyCounter;

    private FilePropertyContainer() {
    }

    public static <T extends TaskFilePropertyBuilder & TaskFilePropertySpec> FilePropertyContainer<T> create() {
        return new FilePropertyContainer<T>();
    }

    public void add(T property) {
        this.properties.add(property);
        this.changed = true;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.changed) {
            for (TaskFilePropertyBuilder propertySpec : this.properties) {
                String propertyName = ((TaskPropertySpec)propertySpec).getPropertyName();
                if (propertyName != null) continue;
                propertyName = "$" + ++this.unnamedPropertyCounter;
                propertySpec.withPropertyName(propertyName);
            }
            this.changed = false;
        }
        return this.properties.iterator();
    }
}

