/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectMapper;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;

public class VisualStudioProjectRegistry
extends DefaultNamedDomainObjectSet<DefaultVisualStudioProject> {
    private final FileResolver fileResolver;
    private final IdeArtifactRegistry ideArtifactRegistry;

    public VisualStudioProjectRegistry(FileResolver fileResolver, Instantiator instantiator, IdeArtifactRegistry ideArtifactRegistry) {
        super(DefaultVisualStudioProject.class, instantiator);
        this.fileResolver = fileResolver;
        this.ideArtifactRegistry = ideArtifactRegistry;
    }

    public VisualStudioProjectConfiguration getProjectConfiguration(VisualStudioTargetBinary targetBinary) {
        String projectName = VisualStudioProjectMapper.getProjectName(targetBinary);
        return ((DefaultVisualStudioProject)this.getByName(projectName)).getConfiguration(targetBinary);
    }

    public VisualStudioProjectConfiguration addProjectConfiguration(VisualStudioTargetBinary nativeBinary) {
        DefaultVisualStudioProject project = this.getOrCreateProject(nativeBinary.getProjectPath(), VisualStudioProjectMapper.getProjectName(nativeBinary), nativeBinary.getComponentName());
        VisualStudioProjectConfiguration configuration = this.createVisualStudioProjectConfiguration(project, nativeBinary, VisualStudioProjectMapper.getConfigurationName(nativeBinary.getVariantDimensions()));
        project.addConfiguration(nativeBinary, configuration);
        this.ideArtifactRegistry.registerIdeArtifact(configuration.getPublishArtifact());
        return configuration;
    }

    private VisualStudioProjectConfiguration createVisualStudioProjectConfiguration(VisualStudioProject project, VisualStudioTargetBinary nativeBinary, String configuration) {
        return (VisualStudioProjectConfiguration)this.getInstantiator().newInstance(VisualStudioProjectConfiguration.class, new Object[]{project, configuration, nativeBinary});
    }

    private DefaultVisualStudioProject getOrCreateProject(String projectPath, String vsProjectName, String componentName) {
        DefaultVisualStudioProject vsProject = (DefaultVisualStudioProject)this.findByName(vsProjectName);
        if (vsProject == null) {
            vsProject = (DefaultVisualStudioProject)this.getInstantiator().newInstance(DefaultVisualStudioProject.class, new Object[]{vsProjectName, projectPath, componentName, this.fileResolver, this.getInstantiator()});
            this.add(vsProject);
            this.ideArtifactRegistry.registerIdeArtifact(vsProject.getPublishArtifact());
        }
        return vsProject;
    }
}

