/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;

public class VisualStudioProjectMapper {
    public static String getProjectName(VisualStudioTargetBinary targetBinary) {
        return VisualStudioProjectMapper.getProjectName(targetBinary.getProjectPath(), targetBinary.getComponentName(), targetBinary.getProjectType());
    }

    public static String getProjectName(String projectPath, String componentName, VisualStudioTargetBinary.ProjectType type) {
        return VisualStudioProjectMapper.projectPrefix(projectPath) + componentName + type.getSuffix();
    }

    public static String getConfigurationName(List<String> variantDimensions) {
        return VisualStudioProjectMapper.makeName(variantDimensions);
    }

    private static String projectPrefix(String projectPath) {
        if (":".equals(projectPath)) {
            return "";
        }
        return projectPath.substring(1).replace(":", "_") + "_";
    }

    private static String makeName(Iterable<String> components) {
        StringBuilder builder = new StringBuilder();
        for (String component : components) {
            if (component == null || component.length() <= 0) continue;
            if (builder.length() == 0) {
                builder.append(component);
                continue;
            }
            builder.append(StringUtils.capitalize((String)component));
        }
        return builder.toString();
    }
}

