/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;

public class VisualStudioProjectConfiguration {
    public static final String ARTIFACT_TYPE = "visualStudioProjectConfiguration";
    private final DefaultVisualStudioProject vsProject;
    private final String name;
    private final String configurationName;
    private final String platformName = "Win32";
    private final VisualStudioTargetBinary binary;

    public VisualStudioProjectConfiguration(DefaultVisualStudioProject vsProject, String configurationName, VisualStudioTargetBinary binary) {
        this.vsProject = vsProject;
        this.configurationName = configurationName;
        this.name = configurationName + "|" + "Win32";
        this.binary = binary;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getPlatformName() {
        return "Win32";
    }

    public VisualStudioTargetBinary getTargetBinary() {
        return this.binary;
    }

    public final String getType() {
        return "Makefile";
    }

    public DefaultVisualStudioProject getProject() {
        return this.vsProject;
    }

    public PublishArtifact getPublishArtifact() {
        return new VisualStudioProjectConfigurationArtifact();
    }

    private class VisualStudioProjectConfigurationArtifact
    extends DefaultPublishArtifact {
        public VisualStudioProjectConfigurationArtifact() {
            super(VisualStudioProjectConfiguration.this.name, "vcxproj", VisualStudioProjectConfiguration.ARTIFACT_TYPE, null, null, null, new Object[]{VisualStudioProjectConfiguration.this.vsProject.getBuildDependencies()});
        }

        public File getFile() {
            return VisualStudioProjectConfiguration.this.vsProject.getProjectFile().getLocation();
        }
    }
}

