/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.component.DefaultBuildIdentifier;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.DefaultProjectPathRegistry;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

public class DefaultIncludedBuildRegistry
implements IncludedBuildRegistry,
Stoppable {
    private final IncludedBuildFactory includedBuildFactory;
    private final DefaultProjectPathRegistry projectRegistry;
    private final IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder;
    private final Map<File, IncludedBuildInternal> includedBuilds = Maps.newLinkedHashMap();

    public DefaultIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, DefaultProjectPathRegistry projectRegistry, IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder, CompositeBuildContext compositeBuildContext) {
        this.includedBuildFactory = includedBuildFactory;
        this.projectRegistry = projectRegistry;
        this.dependencySubstitutionsBuilder = dependencySubstitutionsBuilder;
        compositeBuildContext.setIncludedBuildRegistry((IncludedBuildRegistry)this);
    }

    public boolean hasIncludedBuilds() {
        return !this.includedBuilds.isEmpty();
    }

    public Collection<IncludedBuild> getIncludedBuilds() {
        return (Collection)Cast.uncheckedCast(this.includedBuilds.values());
    }

    public IncludedBuildInternal addExplicitBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        return this.registerBuild(buildDefinition, nestedBuildFactory);
    }

    public IncludedBuild getBuild(final BuildIdentifier buildIdentifier) {
        return (IncludedBuild)CollectionUtils.findFirst(this.includedBuilds.values(), (Spec)new Spec<IncludedBuild>(){

            public boolean isSatisfiedBy(IncludedBuild includedBuild) {
                return includedBuild.getName().equals(buildIdentifier.getName());
            }
        });
    }

    public Collection<Pair<ModuleVersionIdentifier, ProjectComponentIdentifier>> getModuleToProjectMapping(IncludedBuild includedBuild) {
        return ((IncludedBuildInternal)includedBuild).getAvailableModules();
    }

    public void validateExplicitIncludedBuilds(SettingsInternal settings) {
        this.validateIncludedBuilds(settings);
        this.registerRootBuildProjects(settings);
        Collection<IncludedBuild> includedBuilds = this.getIncludedBuilds();
        settings.getGradle().setIncludedBuilds(includedBuilds);
        this.registerProjects(includedBuilds, false);
        this.registerSubstitutions(includedBuilds);
    }

    private void validateIncludedBuilds(SettingsInternal settings) {
        HashSet names = Sets.newHashSet();
        for (IncludedBuild includedBuild : this.includedBuilds.values()) {
            String buildName = includedBuild.getName();
            if (!names.add(buildName)) {
                throw new GradleException("Included build '" + buildName + "' is not unique in composite.");
            }
            if (settings.getRootProject().getName().equals(buildName)) {
                throw new GradleException("Included build '" + buildName + "' collides with root project name.");
            }
            if (settings.findProject(":" + buildName) == null) continue;
            throw new GradleException("Included build '" + buildName + "' collides with subproject of the same name.");
        }
    }

    private void registerSubstitutions(Iterable<IncludedBuild> includedBuilds) {
        for (IncludedBuild includedBuild : includedBuilds) {
            this.dependencySubstitutionsBuilder.build((IncludedBuildInternal)includedBuild);
        }
    }

    public ConfigurableIncludedBuild addImplicitBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        ConfigurableIncludedBuild includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.registerBuild(buildDefinition, nestedBuildFactory);
            this.registerProjects(Collections.singletonList(includedBuild), true);
        }
        return includedBuild;
    }

    private IncludedBuildInternal registerBuild(BuildDefinition buildDefinition, NestedBuildFactory nestedBuildFactory) {
        IncludedBuildInternal includedBuild = this.includedBuilds.get(buildDefinition.getBuildRootDir());
        if (includedBuild == null) {
            includedBuild = this.includedBuildFactory.createBuild(buildDefinition, nestedBuildFactory);
            this.includedBuilds.put(buildDefinition.getBuildRootDir(), includedBuild);
        }
        return includedBuild;
    }

    private void registerRootBuildProjects(SettingsInternal settings) {
        ProjectRegistry settingsProjectRegistry = settings.getProjectRegistry();
        String rootName = ((DefaultProjectDescriptor)settingsProjectRegistry.getRootProject()).getName();
        DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(rootName, true);
        this.registerProjects(Path.ROOT, (BuildIdentifier)buildIdentifier, settingsProjectRegistry.getAllProjects(), false);
    }

    private void registerProjects(Iterable<IncludedBuild> includedBuilds, boolean isImplicitBuild) {
        for (IncludedBuild includedBuild : includedBuilds) {
            Path rootProjectPath = Path.ROOT.child(includedBuild.getName());
            DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(includedBuild.getName());
            Set allProjects = ((IncludedBuildInternal)includedBuild).getLoadedSettings().getProjectRegistry().getAllProjects();
            this.registerProjects(rootProjectPath, (BuildIdentifier)buildIdentifier, allProjects, isImplicitBuild);
        }
    }

    private void registerProjects(Path rootPath, BuildIdentifier buildIdentifier, Set<DefaultProjectDescriptor> allProjects, boolean isImplicitBuild) {
        for (DefaultProjectDescriptor project : allProjects) {
            Path projectIdentityPath = rootPath.append(project.path());
            ProjectComponentIdentifier projectComponentIdentifier = DefaultProjectComponentIdentifier.newProjectId((BuildIdentifier)buildIdentifier, (String)project.getPath());
            this.projectRegistry.add(projectIdentityPath, projectComponentIdentifier, isImplicitBuild);
        }
    }

    public void stop() {
        CompositeStoppable.stoppable(this.includedBuilds.values()).stop();
    }
}

