/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.insight;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyReportHeader;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RequestedVersion;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.ResolvedDependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.SelectionReasonHelper;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvedDependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyResultSorter;
import org.gradle.util.CollectionUtils;

public class DependencyInsightReporter {
    public Collection<RenderableDependency> prepare(Collection<DependencyResult> input, VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator) {
        LinkedList<RenderableDependency> out = new LinkedList<RenderableDependency>();
        List dependencies = CollectionUtils.collect(input, (Transformer)new Transformer<DependencyEdge, DependencyResult>(){

            public DependencyEdge transform(DependencyResult result) {
                if (result instanceof UnresolvedDependencyResult) {
                    return new UnresolvedDependencyEdge((UnresolvedDependencyResult)result);
                }
                return new ResolvedDependencyEdge((ResolvedDependencyResult)result);
            }
        });
        Collection<DependencyEdge> sorted = DependencyResultSorter.sort(dependencies, versionSelectorScheme, versionComparator);
        HashSet<ComponentIdentifier> annotated = new HashSet<ComponentIdentifier>();
        RequestedVersion current = null;
        for (DependencyEdge dependency : sorted) {
            ResolvedVariantResult selectedVariant = dependency.getSelectedVariant();
            if (annotated.add(dependency.getActual())) {
                if (!dependency.getRequested().matchesStrictly(dependency.getActual())) {
                    out.add(new DependencyReportHeader(dependency, selectedVariant));
                    current = new RequestedVersion(dependency.getRequested(), dependency.getActual(), dependency.isResolvable(), null, selectedVariant);
                    out.add(current);
                } else {
                    current = new RequestedVersion(dependency.getRequested(), dependency.getActual(), dependency.isResolvable(), SelectionReasonHelper.getReasonDescription(dependency.getReason()), selectedVariant);
                    out.add(current);
                }
            } else if (!current.getRequested().equals(dependency.getRequested())) {
                current = new RequestedVersion(dependency.getRequested(), dependency.getActual(), dependency.isResolvable(), null, selectedVariant);
                out.add(current);
            }
            current.addChild(dependency);
        }
        return out;
    }
}

