/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal;

import com.google.common.base.Strings;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Named;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;

public class ModuleMetadataFileGenerator {
    private final BuildInvocationScopeId buildInvocationScopeId;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;

    public ModuleMetadataFileGenerator(BuildInvocationScopeId buildInvocationScopeId, ProjectDependencyPublicationResolver projectDependencyResolver) {
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.projectDependencyResolver = projectDependencyResolver;
    }

    public void generateTo(PublicationInternal publication, Collection<? extends PublicationInternal> publications, Writer writer) throws IOException {
        HashMap<SoftwareComponent, ComponentData> coordinates = new HashMap<SoftwareComponent, ComponentData>();
        this.collectCoordinates(publications, coordinates);
        HashMap<SoftwareComponent, SoftwareComponent> owners = new HashMap<SoftwareComponent, SoftwareComponent>();
        this.collectOwners(publications, owners);
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setIndent("  ");
        this.writeComponentWithVariants(publication, (SoftwareComponent)publication.getComponent(), coordinates, owners, jsonWriter);
        jsonWriter.flush();
        writer.append('\n');
    }

    private void collectOwners(Collection<? extends PublicationInternal> publications, Map<SoftwareComponent, SoftwareComponent> owners) {
        for (PublicationInternal publicationInternal : publications) {
            if (!(publicationInternal.getComponent() instanceof ComponentWithVariants)) continue;
            ComponentWithVariants componentWithVariants = (ComponentWithVariants)publicationInternal.getComponent();
            for (SoftwareComponent child : componentWithVariants.getVariants()) {
                owners.put(child, (SoftwareComponent)publicationInternal.getComponent());
            }
        }
    }

    private void collectCoordinates(Collection<? extends PublicationInternal> publications, Map<SoftwareComponent, ComponentData> coordinates) {
        for (PublicationInternal publicationInternal : publications) {
            if (publicationInternal.getComponent() == null) continue;
            ModuleVersionIdentifier moduleVersionIdentifier = publicationInternal.getCoordinates();
            ImmutableAttributes attributes = publicationInternal.getAttributes();
            coordinates.put((SoftwareComponent)publicationInternal.getComponent(), new ComponentData(moduleVersionIdentifier, attributes));
        }
    }

    private void writeComponentWithVariants(PublicationInternal publication, SoftwareComponent component, Map<SoftwareComponent, ComponentData> componentCoordinates, Map<SoftwareComponent, SoftwareComponent> owners, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        this.writeFormat(jsonWriter);
        this.writeIdentity(publication.getCoordinates(), publication.getAttributes(), component, componentCoordinates, owners, jsonWriter);
        this.writeCreator(jsonWriter);
        this.writeVariants(publication, component, componentCoordinates, jsonWriter);
        jsonWriter.endObject();
    }

    private void writeVersionConstraint(VersionConstraint versionConstraint, JsonWriter jsonWriter) throws IOException {
        List rejectedVersions;
        if (DefaultImmutableVersionConstraint.of().equals(versionConstraint)) {
            return;
        }
        jsonWriter.name("version");
        jsonWriter.beginObject();
        if (!versionConstraint.getPreferredVersion().isEmpty()) {
            jsonWriter.name("prefers");
            jsonWriter.value(versionConstraint.getPreferredVersion());
        }
        if (!(rejectedVersions = versionConstraint.getRejectedVersions()).isEmpty()) {
            jsonWriter.name("rejects");
            jsonWriter.beginArray();
            for (String reject : rejectedVersions) {
                jsonWriter.value(reject);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    private void writeIdentity(ModuleVersionIdentifier coordinates, ImmutableAttributes attributes, SoftwareComponent component, Map<SoftwareComponent, ComponentData> componentCoordinates, Map<SoftwareComponent, SoftwareComponent> owners, JsonWriter jsonWriter) throws IOException {
        SoftwareComponent owner = owners.get(component);
        if (owner == null) {
            jsonWriter.name("component");
            jsonWriter.beginObject();
            jsonWriter.name("group");
            jsonWriter.value(coordinates.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(coordinates.getName());
            jsonWriter.name("version");
            jsonWriter.value(coordinates.getVersion());
            this.writeAttributes((AttributeContainer)attributes, jsonWriter);
            jsonWriter.endObject();
        } else {
            ComponentData componentData = componentCoordinates.get(owner);
            ModuleVersionIdentifier ownerCoordinates = componentData.coordinates;
            jsonWriter.name("component");
            jsonWriter.beginObject();
            jsonWriter.name("url");
            jsonWriter.value(this.relativeUrlTo(coordinates, ownerCoordinates));
            jsonWriter.name("group");
            jsonWriter.value(ownerCoordinates.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(ownerCoordinates.getName());
            jsonWriter.name("version");
            jsonWriter.value(ownerCoordinates.getVersion());
            this.writeAttributes((AttributeContainer)componentData.attributes, jsonWriter);
            jsonWriter.endObject();
        }
    }

    private void writeVariants(PublicationInternal publication, SoftwareComponent component, Map<SoftwareComponent, ComponentData> componentCoordinates, JsonWriter jsonWriter) throws IOException {
        boolean started = false;
        for (UsageContext usageContext : ((SoftwareComponentInternal)component).getUsages()) {
            if (!started) {
                jsonWriter.name("variants");
                jsonWriter.beginArray();
                started = true;
            }
            this.writeVariantHostedInThisModule(publication, usageContext, jsonWriter);
        }
        if (component instanceof ComponentWithVariants) {
            for (SoftwareComponent childComponent : ((ComponentWithVariants)component).getVariants()) {
                ComponentData componentData = componentCoordinates.get(childComponent);
                ModuleVersionIdentifier childCoordinates = componentData == null ? null : componentData.coordinates;
                if (childCoordinates == null || !(childComponent instanceof SoftwareComponentInternal)) continue;
                for (UsageContext usageContext : ((SoftwareComponentInternal)childComponent).getUsages()) {
                    if (!started) {
                        jsonWriter.name("variants");
                        jsonWriter.beginArray();
                        started = true;
                    }
                    this.writeVariantHostedInAnotherModule(publication.getCoordinates(), childCoordinates, usageContext, jsonWriter);
                }
            }
        }
        if (started) {
            jsonWriter.endArray();
        }
    }

    private void writeCreator(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("createdBy");
        jsonWriter.beginObject();
        jsonWriter.name("gradle");
        jsonWriter.beginObject();
        jsonWriter.name("version");
        jsonWriter.value(GradleVersion.current().getVersion());
        jsonWriter.name("buildId");
        jsonWriter.value(this.buildInvocationScopeId.getId().asString());
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private void writeFormat(JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("formatVersion");
        jsonWriter.value("0.3");
    }

    private void writeVariantHostedInAnotherModule(ModuleVersionIdentifier coordinates, ModuleVersionIdentifier targetCoordinates, UsageContext variant, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("name");
        jsonWriter.value(variant.getName());
        this.writeAttributes(variant.getAttributes(), jsonWriter);
        jsonWriter.name("available-at");
        jsonWriter.beginObject();
        jsonWriter.name("url");
        jsonWriter.value(this.relativeUrlTo(coordinates, targetCoordinates));
        jsonWriter.name("group");
        jsonWriter.value(targetCoordinates.getGroup());
        jsonWriter.name("module");
        jsonWriter.value(targetCoordinates.getName());
        jsonWriter.name("version");
        jsonWriter.value(targetCoordinates.getVersion());
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private String relativeUrlTo(ModuleVersionIdentifier from, ModuleVersionIdentifier to) {
        StringBuilder path = new StringBuilder();
        path.append("../../");
        path.append(to.getName());
        path.append("/");
        path.append(to.getVersion());
        path.append("/");
        path.append(to.getName());
        path.append("-");
        path.append(to.getVersion());
        path.append(".module");
        return path.toString();
    }

    private void writeVariantHostedInThisModule(PublicationInternal publication, UsageContext variant, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("name");
        jsonWriter.value(variant.getName());
        this.writeAttributes(variant.getAttributes(), jsonWriter);
        this.writeDependencies(variant, jsonWriter);
        this.writeDependencyConstraints(variant, jsonWriter);
        this.writeArtifacts(publication, variant, jsonWriter);
        jsonWriter.endObject();
    }

    private void writeAttributes(AttributeContainer attributes, JsonWriter jsonWriter) throws IOException {
        if (attributes.isEmpty()) {
            return;
        }
        jsonWriter.name("attributes");
        jsonWriter.beginObject();
        TreeMap<String, Attribute> sortedAttributes = new TreeMap<String, Attribute>();
        for (Attribute attribute : attributes.keySet()) {
            sortedAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute attribute : sortedAttributes.values()) {
            jsonWriter.name(attribute.getName());
            Object value = attributes.getAttribute(attribute);
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                jsonWriter.value(b);
                continue;
            }
            if (value instanceof String) {
                String s = (String)value;
                jsonWriter.value(s);
                continue;
            }
            if (value instanceof Named) {
                Named named = (Named)value;
                jsonWriter.value(named.getName());
                continue;
            }
            if (value instanceof Enum) {
                Enum enumValue = (Enum)value;
                jsonWriter.value(enumValue.name());
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot write attribute %s with unsupported value %s of type %s.", attribute.getName(), value, value.getClass().getName()));
        }
        jsonWriter.endObject();
    }

    private void writeArtifacts(PublicationInternal publication, UsageContext variant, JsonWriter jsonWriter) throws IOException {
        if (variant.getArtifacts().isEmpty()) {
            return;
        }
        jsonWriter.name("files");
        jsonWriter.beginArray();
        for (PublishArtifact artifact : variant.getArtifacts()) {
            this.writeArtifact(publication, artifact, jsonWriter);
        }
        jsonWriter.endArray();
    }

    private void writeArtifact(PublicationInternal publication, PublishArtifact artifact, JsonWriter jsonWriter) throws IOException {
        PublicationInternal.PublishedFile publishedFile = publication.getPublishedFile(artifact);
        jsonWriter.beginObject();
        jsonWriter.name("name");
        jsonWriter.value(publishedFile.getName());
        jsonWriter.name("url");
        jsonWriter.value(publishedFile.getUri());
        jsonWriter.name("size");
        jsonWriter.value(artifact.getFile().length());
        jsonWriter.name("sha1");
        jsonWriter.value(HashUtil.sha1((File)artifact.getFile()).asHexString());
        jsonWriter.name("md5");
        jsonWriter.value(HashUtil.createHash((File)artifact.getFile(), (String)"md5").asHexString());
        jsonWriter.endObject();
    }

    private void writeDependencies(UsageContext variant, JsonWriter jsonWriter) throws IOException {
        if (variant.getDependencies().isEmpty()) {
            return;
        }
        jsonWriter.name("dependencies");
        jsonWriter.beginArray();
        for (ModuleDependency moduleDependency : variant.getDependencies()) {
            this.writeDependency((Dependency)moduleDependency, jsonWriter);
        }
        jsonWriter.endArray();
    }

    private void writeDependency(Dependency dependency, JsonWriter jsonWriter) throws IOException {
        String reason;
        jsonWriter.beginObject();
        if (dependency instanceof ProjectDependency) {
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, projectDependency);
            jsonWriter.name("group");
            jsonWriter.value(identifier.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(identifier.getName());
            this.writeVersionConstraint((VersionConstraint)DefaultImmutableVersionConstraint.of((String)identifier.getVersion()), jsonWriter);
        } else {
            jsonWriter.name("group");
            jsonWriter.value(dependency.getGroup());
            jsonWriter.name("module");
            jsonWriter.value(dependency.getName());
            Object vc = dependency instanceof ModuleVersionSelector ? ((ExternalDependency)dependency).getVersionConstraint() : DefaultImmutableVersionConstraint.of((String)Strings.nullToEmpty((String)dependency.getVersion()));
            this.writeVersionConstraint((VersionConstraint)vc, jsonWriter);
        }
        if (dependency instanceof ModuleDependency) {
            this.writeExcludes((ModuleDependency)dependency, jsonWriter);
        }
        if (StringUtils.isNotEmpty((String)(reason = dependency.getReason()))) {
            jsonWriter.name("reason");
            jsonWriter.value(reason);
        }
        jsonWriter.endObject();
    }

    private void writeDependencyConstraints(UsageContext variant, JsonWriter jsonWriter) throws IOException {
        if (variant.getDependencyConstraints().isEmpty()) {
            return;
        }
        jsonWriter.name("dependencyConstraints");
        jsonWriter.beginArray();
        for (DependencyConstraint dependencyConstraint : variant.getDependencyConstraints()) {
            this.writeDependencyConstraint(dependencyConstraint, jsonWriter);
        }
        jsonWriter.endArray();
    }

    private void writeDependencyConstraint(DependencyConstraint dependencyConstraint, JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("group");
        jsonWriter.value(dependencyConstraint.getGroup());
        jsonWriter.name("module");
        jsonWriter.value(dependencyConstraint.getName());
        this.writeVersionConstraint(dependencyConstraint.getVersionConstraint(), jsonWriter);
        String reason = dependencyConstraint.getReason();
        if (StringUtils.isNotEmpty((String)reason)) {
            jsonWriter.name("reason");
            jsonWriter.value(reason);
        }
        jsonWriter.endObject();
    }

    private void writeExcludes(ModuleDependency moduleDependency, JsonWriter jsonWriter) throws IOException {
        Set<DefaultExcludeRule> excludeRules = !moduleDependency.isTransitive() ? Collections.singleton(new DefaultExcludeRule(null, null)) : moduleDependency.getExcludeRules();
        if (excludeRules.isEmpty()) {
            return;
        }
        jsonWriter.name("excludes");
        jsonWriter.beginArray();
        for (ExcludeRule excludeRule : excludeRules) {
            jsonWriter.beginObject();
            jsonWriter.name("group");
            String group = (String)GUtil.elvis((Object)excludeRule.getGroup(), (Object)"*");
            jsonWriter.value(group);
            jsonWriter.name("module");
            String module = (String)GUtil.elvis((Object)excludeRule.getModule(), (Object)"*");
            jsonWriter.value(module);
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    private static class ComponentData {
        private final ModuleVersionIdentifier coordinates;
        private final ImmutableAttributes attributes;

        private ComponentData(ModuleVersionIdentifier coordinates, ImmutableAttributes attributes) {
            this.coordinates = coordinates;
            this.attributes = attributes;
        }
    }
}

