/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.BuildCancelledException;
import org.gradle.api.Project;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.gradle.GradleBuildIdentity;
import org.gradle.tooling.internal.gradle.GradleProjectIdentity;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalBuildControllerVersion2;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.provider.model.ParameterizedToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.tooling.provider.model.UnknownModelException;

class DefaultBuildController
implements InternalBuildController,
InternalBuildControllerVersion2 {
    private final GradleInternal gradle;

    public DefaultBuildController(GradleInternal gradle) {
        this.gradle = gradle;
    }

    @Deprecated
    public BuildResult<?> getBuildModel() throws BuildExceptionVersion1 {
        return new ProviderBuildResult((Object)this.gradle);
    }

    @Deprecated
    public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        return this.getModel(target, modelIdentifier, null);
    }

    public BuildResult<?> getModel(Object target, ModelIdentifier modelIdentifier, Object parameter) throws BuildExceptionVersion1, InternalUnsupportedModelException {
        Object model;
        BuildCancellationToken cancellationToken = (BuildCancellationToken)this.gradle.getServices().get(BuildCancellationToken.class);
        if (cancellationToken.isCancellationRequested()) {
            throw new BuildCancelledException(String.format("Could not build '%s' model. Build cancelled.", modelIdentifier.getName()));
        }
        ProjectInternal project = this.getTargetProject(target);
        ToolingModelBuilder builder = this.getToolingModelBuilder(project, modelIdentifier);
        String modelName = modelIdentifier.getName();
        if (parameter == null) {
            model = builder.buildAll(modelName, (Project)project);
        } else if (builder instanceof ParameterizedToolingModelBuilder) {
            model = this.getParameterizedModel(project, modelName, (ParameterizedToolingModelBuilder)builder, parameter);
        } else {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)new UnknownModelException(String.format("No parameterized builders are available to build a model of type '%s'.", modelName)));
        }
        return new ProviderBuildResult(model);
    }

    private <T> Object getParameterizedModel(ProjectInternal project, String modelName, ParameterizedToolingModelBuilder<T> builder, Object parameter) throws InternalUnsupportedModelException {
        Class expectedParameterType = builder.getParameterType();
        ViewBuilder viewBuilder = new ProtocolToModelAdapter().builder(expectedParameterType);
        Object internalParameter = viewBuilder.build(parameter);
        return builder.buildAll(modelName, internalParameter, (Project)project);
    }

    private ProjectInternal getTargetProject(Object target) {
        ProjectInternal project;
        if (target == null) {
            project = this.gradle.getDefaultProject();
        } else if (target instanceof GradleProjectIdentity) {
            GradleProjectIdentity projectIdentity = (GradleProjectIdentity)target;
            GradleInternal build = this.findBuild((GradleBuildIdentity)projectIdentity);
            project = this.findProject(build, projectIdentity);
        } else if (target instanceof GradleBuildIdentity) {
            GradleBuildIdentity buildIdentity = (GradleBuildIdentity)target;
            project = this.findBuild(buildIdentity).getDefaultProject();
        } else {
            throw new IllegalArgumentException("Don't know how to build models for " + target);
        }
        return project;
    }

    private GradleInternal findBuild(GradleBuildIdentity buildIdentity) {
        GradleInternal build = this.findBuild(this.gradle, buildIdentity);
        if (build != null) {
            return build;
        }
        throw new IllegalArgumentException(buildIdentity.getRootDir() + " is not included in this build");
    }

    private GradleInternal findBuild(GradleInternal rootBuild, GradleBuildIdentity buildIdentity) {
        if (rootBuild.getRootProject().getProjectDir().equals(buildIdentity.getRootDir())) {
            return rootBuild;
        }
        for (IncludedBuild includedBuild : rootBuild.getIncludedBuilds()) {
            GradleInternal matchingBuild = this.findBuild(((IncludedBuildInternal)includedBuild).getConfiguredBuild(), buildIdentity);
            if (matchingBuild == null) continue;
            return matchingBuild;
        }
        return null;
    }

    private ProjectInternal findProject(GradleInternal build, GradleProjectIdentity projectIdentity) {
        return build.getRootProject().project(projectIdentity.getProjectPath());
    }

    private ToolingModelBuilder getToolingModelBuilder(ProjectInternal project, ModelIdentifier modelIdentifier) {
        ToolingModelBuilder builder;
        ToolingModelBuilderRegistry modelBuilderRegistry = (ToolingModelBuilderRegistry)project.getServices().get(ToolingModelBuilderRegistry.class);
        try {
            builder = modelBuilderRegistry.getBuilder(modelIdentifier.getName());
        }
        catch (UnknownModelException e) {
            throw (InternalUnsupportedModelException)new InternalUnsupportedModelException().initCause((Throwable)e);
        }
        return builder;
    }
}

