/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.language.ComponentDependencies;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultComponentDependencies;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftExecutable;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.internal.DefaultSwiftComponent;
import org.gradle.language.swift.internal.DefaultSwiftExecutable;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultSwiftApplication
extends DefaultSwiftComponent
implements SwiftApplication {
    private final ObjectFactory objectFactory;
    private final Property<SwiftExecutable> developmentBinary;
    private final DefaultComponentDependencies dependencies;

    @Inject
    public DefaultSwiftApplication(String name, ObjectFactory objectFactory, FileOperations fileOperations) {
        super(name, fileOperations, objectFactory);
        this.objectFactory = objectFactory;
        this.developmentBinary = objectFactory.property(SwiftExecutable.class);
        this.dependencies = (DefaultComponentDependencies)objectFactory.newInstance(DefaultComponentDependencies.class, new Object[]{this.getNames().withSuffix("implementation")});
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((String)"Swift application", (String)this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public ComponentDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super ComponentDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    public SwiftExecutable addExecutable(String nameSuffix, boolean debuggable, boolean optimized, boolean testable, SwiftPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        SwiftExecutable result = (SwiftExecutable)this.objectFactory.newInstance(DefaultSwiftExecutable.class, new Object[]{this.getName() + StringUtils.capitalize((String)nameSuffix), this.getModule(), debuggable, optimized, testable, this.getSwiftSource(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    public Property<SwiftExecutable> getDevelopmentBinary() {
        return this.developmentBinary;
    }
}

