/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncludeFileState;
import org.gradle.language.nativeplatform.internal.incremental.SourceFileState;

public class CompilationStateSerializer
implements Serializer<CompilationState> {
    private final Serializer<File> fileSerializer;
    private final Serializer<HashCode> hashSerializer = new HashCodeSerializer();

    public CompilationStateSerializer() {
        this.fileSerializer = new BaseSerializerFactory().getSerializerFor(File.class);
    }

    public CompilationState read(Decoder decoder) throws Exception {
        HashMap<Integer, IncludeFileState> ids = new HashMap<Integer, IncludeFileState>();
        int sourceFileCount = decoder.readSmallInt();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < sourceFileCount; ++i) {
            File sourceFile = (File)this.fileSerializer.read(decoder);
            HashCode sourceHashCode = (HashCode)this.hashSerializer.read(decoder);
            int includeFileCount = decoder.readSmallInt();
            ImmutableSet.Builder includeFileStateBuilder = ImmutableSet.builder();
            for (int j = 0; j < includeFileCount; ++j) {
                int id = decoder.readSmallInt();
                IncludeFileState includeFileState = (IncludeFileState)ids.get(id);
                if (includeFileState == null) {
                    File includeFile = (File)this.fileSerializer.read(decoder);
                    HashCode includeHashCode = (HashCode)this.hashSerializer.read(decoder);
                    includeFileState = new IncludeFileState(includeHashCode, includeFile);
                    ids.put(id, includeFileState);
                }
                includeFileStateBuilder.add((Object)includeFileState);
            }
            builder.put((Object)sourceFile, (Object)new SourceFileState(sourceHashCode, (ImmutableSet<IncludeFileState>)includeFileStateBuilder.build()));
        }
        return new CompilationState((ImmutableMap<File, SourceFileState>)builder.build());
    }

    public void write(Encoder encoder, CompilationState value) throws Exception {
        HashMap<File, Integer> ids = new HashMap<File, Integer>();
        encoder.writeSmallInt(value.getFileStates().size());
        for (Map.Entry entry : value.getFileStates().entrySet()) {
            SourceFileState sourceFileState = (SourceFileState)entry.getValue();
            this.fileSerializer.write(encoder, entry.getKey());
            this.hashSerializer.write(encoder, (Object)sourceFileState.getHash());
            encoder.writeSmallInt(sourceFileState.getResolvedIncludes().size());
            for (IncludeFileState includeFileState : sourceFileState.getResolvedIncludes()) {
                Integer id = (Integer)ids.get(includeFileState.getIncludeFile());
                if (id == null) {
                    id = ids.size();
                    ids.put(includeFileState.getIncludeFile(), id);
                    encoder.writeSmallInt(id.intValue());
                    this.fileSerializer.write(encoder, (Object)includeFileState.getIncludeFile());
                    this.hashSerializer.write(encoder, (Object)includeFileState.getHash());
                    continue;
                }
                encoder.writeSmallInt(id.intValue());
            }
        }
    }
}

